#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_PatientTransfusionComment : BaseTest 
	{
		
		private DataTable _dtPatientTransfusionComment;
		private BOL.PatientTransfusionComment _tstPTC;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				_dtPatientTransfusionComment = UnitTestUtil.RunSQLGetDataTable( "SELECT TOP 1 * FROM PatientTransfusionComment WHERE PatientTransfusionGuid IS NOT NULL AND PatientTransfusionReactionGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false );
				if (_dtPatientTransfusionComment.Rows.Count == 0)
				{
					new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
					new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveSpecimenChecks_Pass();
//
//
//					Guid ptrGuid = DataCreator.GetRandomRecordGuid(TABLES.PatientTransfusionReaction.TableName, "RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
//					Guid ptGuid = DataCreator.GetRandomRecordGuid(TABLES.PatientTransfusion.TableName, "RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
//
//					DataTable dtPRTC = SprocHelper.GetInsertPatientTransfusionCommentSprocTable(Guid.NewGuid(), ptrGuid);
//					dtPRTC.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionGuid, typeof(Guid));
//					dtPRTC.Rows[0][TABLES.PatientTransfusionComment.PatientTransfusionGuid] = ptGuid;
//
//					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertPatientTransfusionComment.StoredProcName, dtPRTC);

					_dtPatientTransfusionComment = UnitTestUtil.RunSQLGetDataTable( "SELECT TOP 1 * FROM PatientTransfusionComment WHERE PatientTransfusionGuid IS NOT NULL AND PatientTransfusionReactionGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true );
				}
				
				this.RefreshData = false;
			}

			_tstPTC = new BOL.PatientTransfusionComment();
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.PatientTransfusionComment tmpPTC = new BOL.PatientTransfusionComment(this._dtPatientTransfusionComment.Rows[0]);

			Assert.IsNotNull(tmpPTC);
			Assert.AreEqual(tmpPTC.PatientTransfusionCommentGuid, (System.Guid)this._dtPatientTransfusionComment.Rows[0][TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void Ctor_Enum_Pass()
		{
			Common.PatientTransfusionCommentCategoryCode tstValue = Common.PatientTransfusionCommentCategoryCode.ImplicatedUnits;

			BOL.PatientTransfusionComment tmpPTC = new BOL.PatientTransfusionComment(tstValue);

			Assert.IsNotNull(tmpPTC);
			Assert.AreEqual(tmpPTC.CommentCategoryCode, string.Concat("T", (int)tstValue));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Enum_Fail()
		{
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull(this._tstPTC);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void CannedCommentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPTC.CannedCommentGuid = tstValue;

			Assert.AreEqual(this._tstPTC.CannedCommentGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CannedCommentGuid_Fail()
		{
		}

		[Test]
		public void CommentCategoryCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPTC.CommentCategoryCode = tstValue;

			Assert.AreEqual(this._tstPTC.CommentCategoryCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CommentCategoryCode_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPTC.DivisionCode = tstValue;

			Assert.AreEqual(this._tstPTC.DivisionCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail()
		{
		}

		[Test]
		public void PatientTransfusionCommentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPTC.PatientTransfusionCommentGuid = tstValue;

			Assert.AreEqual(this._tstPTC.PatientTransfusionCommentGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionCommentGuid_Fail()
		{
		}

		[Test]
		public void PatientTransfusionCommentText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPTC.PatientTransfusionCommentText = tstValue;

			Assert.AreEqual(this._tstPTC.PatientTransfusionCommentText, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionCommentText_Fail()
		{
		}

		[Test]
		public void PatientTransfusionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPTC.PatientTransfusionGuid = tstValue;

			Assert.AreEqual(this._tstPTC.PatientTransfusionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionGuid_Fail()
		{
		}

		[Test]
		public void PatientTransfusionReactionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPTC.PatientTransfusionReactionGuid = tstValue;

			Assert.AreEqual(this._tstPTC.PatientTransfusionReactionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionReactionGuid_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPTC.RecordStatusCode = tstValue;

			Assert.AreEqual(this._tstPTC.RecordStatusCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void PreTransfusionIndicator_Pass()
		{
			bool tstValue = (!this._tstPTC.PreTransfusionIndicator);

			this._tstPTC.PreTransfusionIndicator = tstValue;

			Assert.AreEqual(this._tstPTC.PreTransfusionIndicator, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PreTransfusionIndicator_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.PatientTransfusionComment tmpPTC = new BOL.PatientTransfusionComment(this._dtPatientTransfusionComment.Rows[0]);
			
			DataRow drTest = tmpPTC.LoadDataRowFromThis(this._dtPatientTransfusionComment.NewRow());

			Assert.IsTrue(drTest[TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid].ToString() == tmpPTC.PatientTransfusionCommentGuid.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void GetComments_Pass()
		{
			System.Guid ptGuid = (System.Guid)this._dtPatientTransfusionComment.Rows[0][TABLES.PatientTransfusionComment.PatientTransfusionGuid];
			System.Guid ptrGuid = (System.Guid)this._dtPatientTransfusionComment.Rows[0][TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid];

			System.Collections.ArrayList alTest = BOL.PatientTransfusionComment.GetComments(ptGuid, ptrGuid);

			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void GetComments_Fail()
		{
			System.Guid ptGuid = System.Guid.NewGuid();
			System.Guid ptrGuid = System.Guid.NewGuid();

			System.Collections.ArrayList alTest = BOL.PatientTransfusionComment.GetComments(ptGuid, ptrGuid);

			Assert.IsTrue(alTest.Count >= 0);
		}



	}
}

#endif
